/* 
 * prids.c 
 *
 * Виводить власні ідентифікатори (PID, PPID, PGID, SID), свій
 * командний рядок та командні рядки, асоційовані з деякими
 * іншими процесами, пов'язаними з даним (батьківського процесу, 
 * лідера групи процесів, лідера сеансу) до і після демонізації.
 * Командні рядки отримує за допомогою зовнішньої програми ps, 
 * яку запускає через функцію system().
 * Ілюструє порядок застосування функцій system(), daemon().
 *
 */

#include <errno.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
/* Для getsid(), getpgid() */
#define __USE_XOPEN_EXTENDED
#include <unistd.h>


void print_command(unsigned int pid)
{
        char cmd[50];

        sprintf(cmd, "ps -p %u -o cmd=", pid);
        system(cmd);
}

void print_ids()
{
        unsigned int id;

        id = (unsigned int) getpid();
        printf("The process ID is %u\n", id);
        printf("Current process command line:\n");
        print_command(id);

        id = (unsigned int) getppid();
        printf("Parent process ID is %u\n", id);
        printf("Parent process command line:\n");
        print_command(id);

#if 0
        id = (unsigned int) getpgrp();
#endif
        id = (unsigned int) getpgid(0);	
        printf("The process group ID is %u\n", id);
        printf("Group leader command line:\n");
        print_command(id);

        id = (unsigned int) getsid(0);
        printf("The process session ID is %u\n", id);
        printf("Session leader command line:\n");
        print_command(id);
}

int main()
{
        char outfile[] = "myout.txt";

        /* Виводить ідентифікатори. */
        print_ids();

        /* Перенаправляє стандартні потоки виведення. */
        if (freopen(outfile, "w", stdout) == NULL) {
                fprintf(stderr, "Can't associate stdout with file %s:"
                                        " %s\n", outfile, strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Встановлює для потоку stdout порядкову буферизацію.
           Еквівалент setvbuf(stdout, (char *)NULL, _IOLBF, 0); */
        setlinebuf(stdout);
        if (freopen(outfile, "w", stderr) == NULL) {
                fprintf(stderr, "Can't associate stderr with file"
                                " %s: %s\n", outfile, strerror(errno));
                exit(EXIT_FAILURE);
        }
        /* Відключає для потоку stderr буферизацію.
           Еквівалент setvbuf(stderr, (char *)NULL, _IONBF, BUFSIZ); */
        setbuf(stderr, NULL);
        /* Закриває стандартний потік уведення. */
        if (fclose(stdin) == EOF)
                fprintf(stderr, "Error closing stdin: %s\n",
                                                strerror(errno));

        /* Демонізується. */
        if (daemon(1, 1) != 0) {
                fprintf(stderr, "Can't daemonize: %s\n", strerror(errno));
                exit(EXIT_FAILURE);
        }

        /* Чекає, доки завершиться батьківський процес. */
        sleep(1);
        /* Виводить ідентифікатори. */
        print_ids();
#if 0
        pause();
#endif
        exit(EXIT_SUCCESS);
} 
